<?Lassoscript
// Last modified: 1/15/07 by ECL, Landmann InterActive
// Prepared for Lasso Summit 07

// FUNCTIONALITY
// Changelog - Keeps track of changes to multiple database tables
// Create new array called FormArray from the Action_Params
// Then compare the form array with the database array to find differences
// Comparison ignores items beginning with a dash or equaling "Update" or "Bug_ID"
// and also anything beginning with a dash '-' which are Lasso operators
// Create a new "cleaned" array called FormArrayClean from the items we want to compare

// Debugging
// Var:'svDebug' = 'Y';

// ============= ADD ========
If: $vAction == 'Add';
	
	Var:'SQLAddChangeTableAdd' = 
		'INSERT INTO ' $svChangelogTable ' SET
		Bug_ID="' $vNewBug_ID '",' '
		wg_id="' $svUser_WGID '",' '
		Fieldname="NewIssue",
		Old_Value="",
		New_Value="",
		User_ID="' $svUser_ID '",
		DateModified="' (Date_Format:(Date_GetCurrentDate),-DateFormat='%Y-%m-%d') '"';
	
	Inline: $IV_AddChangelog, -SQL=$SQLAddChangeTableAdd;
		If: (Error_CurrentError) != (Error_NoError);
			Var:'vError' = '9001';
			Var:'vOption"' = 'Writing changelog failed [Error 9001]';
		/If;
	/Inline;

// ============= UPDATE ========
Else: $vAction == 'Update';

	If: $svDebug == 'Y';
		'<br>\r';
		'41: <b>Action_Params</b> = ' (Action_Params) '<br>\n';
	/If;
	
	// Loop through the FormArray and clean it of all the Lasso operators
	// Remove "Update" too, which was the value of the form button
	Loop:($FormArray)->Size;
		If: !(($FormArray->get:(Loop_Count)->first)->(beginswith:'-') ||
			(($FormArray->get:(Loop_Count)->first) == 'Update') ||
			(($FormArray->get:(Loop_Count)->first) == 'Action') ||
			(($FormArray->get:(Loop_Count)->first) == 'BugID') ||
			(($FormArray->get:(loop_count)->first) == 'Process')); 
				$FormArrayClean-> insert:($FormArray->get:(Loop_Count));
		/If;
	/Loop;
	
	// Sorting the array
	$FormArrayClean->(Sort:True);
	
	If: $svDebug == 'Y';
		'<br>\r';
		'61: <b>FormArrayClean</b> is <b> ' ($FormArrayClean->Size) '</b> elements<br>\n';
		'61: <b>FormArrayClean</b> = ' $FormArrayClean ' <br>\n';
	/If;
	
	// Getting the bug record
	Inline: $IV_SearchBugs, 'Bug_ID' = $vBug_ID;
	
		// Creating Array of all fields and values
		Var:'DBArray' = (Array:
			'Project_ID'=		(Field:'Project_ID'),
			'Version_ID'=		(Field:'Version_ID'),
			'ClosedInVers_ID'=	(Field:'ClosedInVers_ID'),
			'ToBeClosedVers_ID'=(Field:'ToBeClosedVers_ID'),
			'Title'=			(Field:'Title'),
			'Description'=		(Field:'Description'),
			'Assigned_To'=		(Field:'Assigned_To'),
			'URL'=				(Field:'URL'),
			'Severity_ID'=		(Field:'Severity_ID'),
			'Priority_ID'=		(Field:'Priority_ID'),
			'Status_ID'=		(Field:'Status_ID'),
			'Resolution_ID'=	(Field:'Resolution_ID'),
			'Browser_ID'=		(Field:'Browser_ID'),
			'OS_ID'=			(Field:'OS_ID'));
	
	/Inline;
	
	// Sort the Array
	$DBArray->(Sort:True);
	
	// TESTING OVERRIDE
	/*$DBArray = (array:
		'Assigned_To' = 'XXXXXX',
		'Browser_ID' = '5',
		'ClosedInVers_ID' = '0',
		'Description' = 'Weasel can\'t log into system. Gets "no user found" message. See the screenshot.',
		'OS_ID' = '33',
		'Priority_ID' = '2',
		'Project_ID' = 'fssG8EodNLqN',
		'Resolution_ID' = '4',
		'Severity_ID' = '4',
		'Status_ID' = '6',
		'Title' = 'Weasel can\'t log in',
		'ToBeClosedVers_ID' = '10',
		'URL' = '/login.lasso',
		'Version_ID' = '1');
	*/
	If: $svDebug == 'Y';
		'<br>\n';
		'109: <b>DBArray</b> is <b> ' ($DBArray->Size) '</b> elements<br>\n';
		'109: <b>DBArray (sorted)</b> is ' $DBArray '<br>\n';
	/If;
	
	// Loop through the two arrays, comparing for differences
	Loop:($FormArrayClean)->size;
	
		If: $svDebug == 'Y';
			'<br>\n';
			'118: Loop_Count: ' (Loop_Count) '<br>\n';
			'118: FormArrayClean Fieldname: ' ($FormArrayClean-> Get:(Loop_Count)->first) '<br>\n';
			'118: DBArray Fieldname: ' ($DBArray-> Get:(Loop_Count)->first) '<br>\n';
		/If;
	
		If: (($FormArrayClean->(Get:(Loop_Count))->First) != ($DBArray->(Get:(Loop_Count))->First));
	
			// If fields don`t match, Set error 9001, Update Failed
			Var:'vError' = '9001';
			Var:'vOption' = 'Update Failed';
	
			If: $svDebug == 'Y';
				'<br>\r';
				'<b>131: Array Names Out of Sync!</b><br>\n';
				'Fieldname: ' ($FormArrayClean->(Get:(Loop_Count))->first) '<br>\n';
				'&nbsp;&nbsp;&nbsp;&nbsp; 131: Old Name: ' ($FormArrayClean->(get:(Loop_Count))->first) '<br>\n';
				'&nbsp;&nbsp;&nbsp;&nbsp; 131: New Name: ' ($DBArray->(get:(Loop_Count))->first) '<br>\n';
			/If;
	
		// Here is where the business gets done
		// If an action_param is different than the database, write out the change record to the Changes table
		Else;
	
			If: (($FormArrayClean->(Get:(Loop_Count))->Second) != ($DBArray->(Get:(Loop_Count))->Second));
		
				If: $svDebug == 'Y';
					'<b>144: Changed Field Hit!</b><br>\n';
					'Fieldname: <b>' ($FormArrayClean->Get:(Loop_Count)->first) '</b><br>\n';
					'Value: <b>' ($FormArrayClean->Get:(Loop_Count)->second) '</b><br>\n';
						'&nbsp;&nbsp;&nbsp;&nbsp; 144: New Value: ' ($FormArrayClean->Get:(Loop_Count)->second) '<br>\n';
						'&nbsp;&nbsp;&nbsp;&nbsp; 144: Old Value: ' ($DBArray->Get:(Loop_Count)->second) '<br>\n';
				/If;
		
				Var:'SQLAddChangeTable' = 
					'INSERT INTO ' $svChangelogTable ' SET
					Bug_ID="' $vBug_ID '",' '
					wg_id="' $svUser_WGID '",' '
					Fieldname="' ($FormArrayClean->Get:(Loop_Count)->first) '",
					Old_Value="' ($DBArray->Get:(Loop_Count)->second) '",
					New_Value="' ($FormArrayClean->Get:(Loop_Count)->second) '",
					User_ID="' ($svUser_ID) '",
					DateModified="' (Date_Format:(Date_GetCurrentDate),-DateFormat='%Y-%m-%d') '"';
		
				If: $svDebug == 'Y';
					'162: SQLAddChangeTable: ' $SQLAddChangeTable '<br>\n';
				/If;
		
				Inline: $IV_AddChangelog, -SQL=$SQLAddChangeTable;
					If: (Error_CurrentError) != (Error_NoError);
						Var:'vError' = '9001';
						Var:'vOption"' = 'Writing changelog failed [Error 9001]';
						'169: Error_CurrentError: ' (Error_CurrentError) '<br>\n';
					Else;
						'169: Error_CurrentError: ' (Error_CurrentError) '<br>\n';
					/If;
				/Inline;
		
			Else;
				If: $svDebug == 'Y';
					'&nbsp;&nbsp;&nbsp;&nbsp;177: Processed Field, No Change<br>\n';
				/If;
			/If;
		/If;
	
	/Loop;

// ============= COMMENT ========
Else: $vAction == 'Add Comment';
	
	Var:'SQLAddChangeTableComment' = 
		'INSERT INTO ' $svChangelogTable ' SET
		Bug_ID="' $vBug_ID '",' '
		wg_id="' $svUser_WGID '",' '
		Fieldname="Comment",
		Old_Value="' $vNewComment_ID '",
		New_Value="",
		User_ID="' $svUser_ID '",
		DateModified="' (Date_Format:(Date_GetCurrentDate),-DateFormat='%Y-%m-%d') '"';
	
	Inline: $IV_AddChangelog, -SQL=$SQLAddChangeTableComment;
		If: (Error_CurrentError) != (Error_NoError);
			Var:'vError' = '9001';
			Var:'vOption"' = 'Writing changelog failed [Error 9001]';
		/If;
	/Inline;

// ============= ATTACHMENT ========
Else: $vAction == 'Upload';

	Var:'SQLAddChangeTableAttach' = 
		'INSERT INTO ' $svChangelogTable ' SET
		Bug_ID="' $vBug_ID '",' '
		wg_id="' $svUser_WGID '",' '
		Fieldname="Attachment",
		Old_Value="' $vNewAttach_ID '",
		New_Value="",
		User_ID="' $svUser_ID '",
		DateModified="' (Date_Format:(Date_GetCurrentDate),-DateFormat='%Y-%m-%d') '"';
	
	Inline: $IV_AddChangelog, -SQL=$SQLAddChangeTableAttach;
		If: (Error_CurrentError) != (Error_NoError);
			Var:'vError' = '9001';
			Var:'vOption"' = 'Writing changelog failed [Error 9001]';
		/If;
	/Inline;
/If;

?>